<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use App\Models\Booking;

class BookingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $bookings = Booking::whereAgentId(auth()->id())->with('package')->latest()->get();

        return view('agent.booking.index', compact('bookings'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Booking $booking)
    {
        if ($booking->agent_id != user()->id) {
            abort(403, 'Sorry! You are not authorized to view this booking information.');
        }

        return view('user.booking.show', compact('booking'));
    }
}
